﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Web;
using System.Web.UI;
using System.Web.UI.WebControls;
using VIRP.EFR.DAL;

namespace VIRP_WEB.Custom.EFR
{
    public partial class AdminListReferenceRanges : EfrBasePage
    {
        protected override void Page_Load(object sender, EventArgs e)
        {
            //VIRP.EFR.DAL.STD_ANALYTE_TEST_REFERENCE_RANGEDB
            if (!IsPostBack)
            {
                HiddenFieldRegistryName.Value = "EFR";
                GridViewReferenceRanges.Caption = "";

                ReplacePageTitle("EFR Administration > Reference Ranges");

                // Added for 508 compliance with GridView column headers and footer
                Page.ClientScript.RegisterStartupScript(GetType(), "UpdateGridView", "UpdateGridView('" + GridViewReferenceRanges.ClientID + "');", true);
            }
        }

        protected void GridViewReferenceRanges_RowCommand(object sender, GridViewCommandEventArgs e)
        {
            switch (e.CommandName)
            {
                case "Edit":
                    var index1 = Convert.ToInt32(e.CommandArgument);
                    GridViewReferenceRanges.SelectedIndex = index1;
                    var id1 = Convert.ToInt32(GridViewReferenceRanges.SelectedValue);

                    Response.Redirect("AdminEditReferenceRange.aspx?id=" + id1);
                    break;
            }

            GridViewReferenceRanges.SelectedIndex = -1;
        }
    }
}
